<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>

<header class="site-header">
    <!-- Header Top -->
    <div class="header-top">
        <div class="container">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div>
                    <span>📞 +90 (212) 555 0123</span>
                    <span style="margin-left: 20px;">✉️ info@firmarehberi.com</span>
                </div>
                <div>
                    <a href="#" style="color: white; text-decoration: none; margin-left: 15px;">Giriş Yap</a>
                    <a href="#" style="color: white; text-decoration: none; margin-left: 15px;">Kayıt Ol</a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Header Main -->
    <div class="header-main">
        <div class="container">
            <div class="header-content">
                <div class="logo">
                    <?php if (has_custom_logo()) : ?>
                        <?php the_custom_logo(); ?>
                    <?php else : ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                            <?php bloginfo('name'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                
                <nav class="main-nav">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_id' => 'primary-menu',
                        'container' => false,
                        'fallback_cb' => 'firma_rehberi_fallback_menu',
                    ));
                    ?>
                </nav>
                
                <div class="header-search">
                    <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                        <input type="search" name="s" placeholder="Firma, ilan ara..." value="<?php echo get_search_query(); ?>">
                        <button type="submit">🔍</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</header>

<?php
// Fallback menu function
function firma_rehberi_fallback_menu() {
    echo '<ul>';
    echo '<li><a href="' . esc_url(home_url('/')) . '">Ana Sayfa</a></li>';
    echo '<li><a href="' . get_post_type_archive_link('firma') . '">Firma Rehberi</a></li>';
    echo '<li><a href="' . get_post_type_archive_link('ilan') . '">İlanlar</a></li>';
    echo '<li><a href="' . get_permalink(get_option('page_for_posts')) . '">Haberler</a></li>';
    echo '<li><a href="' . esc_url(home_url('/iletisim')) . '">İletişim</a></li>';
    echo '</ul>';
}
?>
