<?php get_header(); ?>

<main class="main-content">
    <div class="container">
        <div class="search-header">
            <h1 class="search-title">
                <?php if (have_posts()) : ?>
                    "<?php echo get_search_query(); ?>" için arama sonuçları
                <?php else : ?>
                    Arama sonucu bulunamadı
                <?php endif; ?>
            </h1>
            <p class="search-count">
                <?php
                global $wp_query;
                if (have_posts()) {
                    echo $wp_query->found_posts . ' sonuç bulundu';
                } else {
                    echo 'Aradığınız kriterlere uygun sonuç bulunamadı';
                }
                ?>
            </p>
        </div>
        
        <!-- Arama Formu -->
        <div class="search-form-section">
            <form role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>" class="search-form">
                <div class="search-input-group">
                    <input type="search" name="s" placeholder="Firma, ilan, haber ara..." value="<?php echo get_search_query(); ?>" class="search-input">
                    <button type="submit" class="search-button">🔍 Ara</button>
                </div>
                <div class="search-filters">
                    <select name="post_type" class="search-filter">
                        <option value="">Tüm İçerikler</option>
                        <option value="firma" <?php selected(get_query_var('post_type'), 'firma'); ?>>Firmalar</option>
                        <option value="ilan" <?php selected(get_query_var('post_type'), 'ilan'); ?>>İlanlar</option>
                        <option value="post" <?php selected(get_query_var('post_type'), 'post'); ?>>Haberler</option>
                    </select>
                </div>
            </form>
        </div>
        
        <?php if (have_posts()) : ?>
            <div class="search-results">
                <?php while (have_posts()) : the_post(); ?>
                    <article class="search-result-item">
                        <div class="result-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium'); ?>
                            <?php else : ?>
                                <div class="no-image">
                                    <?php
                                    $post_type = get_post_type();
                                    if ($post_type == 'firma') echo '🏢';
                                    elseif ($post_type == 'ilan') echo '📋';
                                    else echo '📰';
                                    ?>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="result-content">
                            <div class="result-meta">
                                <span class="result-type">
                                    <?php
                                    $post_type = get_post_type();
                                    if ($post_type == 'firma') echo 'Firma';
                                    elseif ($post_type == 'ilan') echo 'İlan';
                                    else echo 'Haber';
                                    ?>
                                </span>
                                <span class="result-date">📅 <?php echo get_the_date(); ?></span>
                            </div>
                            
                            <h2 class="result-title">
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                            </h2>
                            
                            <div class="result-excerpt">
                                <?php echo wp_trim_words(get_the_excerpt(), 25); ?>
                            </div>
                            
                            <?php if (get_post_type() == 'firma') : ?>
                                <div class="result-details">
                                    <?php if (get_post_meta(get_the_ID(), 'phone', true)) : ?>
                                        <span class="detail">📞 <?php echo get_post_meta(get_the_ID(), 'phone', true); ?></span>
                                    <?php endif; ?>
                                    <?php if (get_post_meta(get_the_ID(), 'rating', true)) : ?>
                                        <span class="detail">
                                            <?php 
                                            $rating = get_post_meta(get_the_ID(), 'rating', true);
                                            for ($i = 1; $i <= 5; $i++) {
                                                echo $i <= $rating ? '⭐' : '☆';
                                            }
                                            ?>
                                        </span>
                                    <?php endif; ?>
                                </div>
                            <?php elseif (get_post_type() == 'ilan') : ?>
                                <div class="result-details">
                                    <?php if (get_post_meta(get_the_ID(), 'price', true)) : ?>
                                        <span class="detail price">💰 <?php echo get_post_meta(get_the_ID(), 'price', true); ?></span>
                                    <?php endif; ?>
                                    <?php if (get_post_meta(get_the_ID(), 'location', true)) : ?>
                                        <span class="detail">📍 <?php echo get_post_meta(get_the_ID(), 'location', true); ?></span>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                            
                            <div class="result-categories">
                                <?php
                                $categories = get_the_category();
                                if ($categories) :
                                    foreach ($categories as $category) :
                                ?>
                                    <span class="category-tag"><?php echo $category->name; ?></span>
                                <?php 
                                    endforeach;
                                endif;
                                ?>
                            </div>
                        </div>
                    </article>
                <?php endwhile; ?>
            </div>
            
            <!-- Pagination -->
            <div class="pagination">
                <?php
                echo paginate_links(array(
                    'prev_text' => '← Önceki',
                    'next_text' => 'Sonraki →',
                    'mid_size' => 2,
                ));
                ?>
            </div>
        <?php else : ?>
            <div class="no-results">
                <div class="no-results-content">
                    <h2>Sonuç bulunamadı</h2>
                    <p>Aradığınız "<strong><?php echo get_search_query(); ?></strong>" için herhangi bir sonuç bulunamadı.</p>
                    <div class="no-results-suggestions">
                        <h3>Öneriler:</h3>
                        <ul>
                            <li>Farklı anahtar kelimeler deneyin</li>
                            <li>Daha genel terimler kullanın</li>
                            <li>Yazım hatalarını kontrol edin</li>
                            <li>Eş anlamlı kelimeler deneyin</li>
                        </ul>
                    </div>
                    <a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-primary">Ana Sayfaya Dön</a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</main>

<style>
.search-header {
    text-align: center;
    margin: 40px 0 60px 0;
}

.search-title {
    font-size: 36px;
    font-weight: 700;
    color: #2c3e50;
    margin-bottom: 15px;
}

.search-count {
    font-size: 18px;
    color: #666;
}

.search-form-section {
    background: white;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 3px 15px rgba(0,0,0,0.1);
    margin-bottom: 40px;
}

.search-form {
    display: flex;
    gap: 20px;
    align-items: end;
    flex-wrap: wrap;
}

.search-input-group {
    flex: 1;
    min-width: 300px;
    display: flex;
}

.search-input {
    flex: 1;
    padding: 15px 20px;
    border: 2px solid #e0e0e0;
    border-radius: 25px 0 0 25px;
    font-size: 16px;
    outline: none;
    transition: border-color 0.3s;
}

.search-input:focus {
    border-color: #e74c3c;
}

.search-button {
    padding: 15px 25px;
    background: #e74c3c;
    color: white;
    border: none;
    border-radius: 0 25px 25px 0;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: background 0.3s;
}

.search-button:hover {
    background: #c0392b;
}

.search-filter {
    padding: 15px 20px;
    border: 2px solid #e0e0e0;
    border-radius: 25px;
    font-size: 16px;
    background: white;
    min-width: 150px;
}

.search-results {
    display: grid;
    gap: 30px;
    margin-bottom: 60px;
}

.search-result-item {
    background: white;
    border-radius: 15px;
    padding: 30px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    display: flex;
    gap: 25px;
    transition: transform 0.3s, box-shadow 0.3s;
}

.search-result-item:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(0,0,0,0.15);
}

.result-image {
    width: 150px;
    height: 150px;
    flex-shrink: 0;
    border-radius: 10px;
    overflow: hidden;
}

.result-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}

.no-image {
    width: 100%;
    height: 100%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 48px;
}

.result-content {
    flex: 1;
}

.result-meta {
    display: flex;
    gap: 15px;
    margin-bottom: 10px;
    font-size: 14px;
}

.result-type {
    background: #e74c3c;
    color: white;
    padding: 4px 12px;
    border-radius: 15px;
    font-weight: 600;
    font-size: 12px;
}

.result-date {
    color: #666;
}

.result-title {
    font-size: 24px;
    font-weight: 600;
    margin-bottom: 15px;
    line-height: 1.3;
}

.result-title a {
    color: #2c3e50;
    text-decoration: none;
}

.result-title a:hover {
    color: #e74c3c;
}

.result-excerpt {
    color: #666;
    line-height: 1.6;
    margin-bottom: 15px;
}

.result-details {
    display: flex;
    gap: 20px;
    margin-bottom: 15px;
    flex-wrap: wrap;
}

.detail {
    font-size: 14px;
    color: #666;
}

.detail.price {
    font-weight: 600;
    color: #e74c3c;
}

.result-categories {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.category-tag {
    background: #f8f9fa;
    color: #666;
    padding: 4px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 500;
}

.no-results {
    text-align: center;
    padding: 80px 20px;
    background: white;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
}

.no-results-content h2 {
    font-size: 32px;
    color: #2c3e50;
    margin-bottom: 20px;
}

.no-results-content p {
    font-size: 18px;
    color: #666;
    margin-bottom: 30px;
}

.no-results-suggestions {
    text-align: left;
    max-width: 400px;
    margin: 0 auto 30px;
}

.no-results-suggestions h3 {
    font-size: 20px;
    color: #2c3e50;
    margin-bottom: 15px;
}

.no-results-suggestions ul {
    list-style: none;
    padding: 0;
}

.no-results-suggestions li {
    padding: 8px 0;
    color: #666;
    position: relative;
    padding-left: 20px;
}

.no-results-suggestions li:before {
    content: "•";
    color: #e74c3c;
    position: absolute;
    left: 0;
}

@media (max-width: 768px) {
    .search-form {
        flex-direction: column;
    }
    
    .search-input-group {
        min-width: 100%;
    }
    
    .search-result-item {
        flex-direction: column;
    }
    
    .result-image {
        width: 100%;
        height: 200px;
    }
    
    .result-details {
        flex-direction: column;
        gap: 10px;
    }
}
</style>

<?php get_footer(); ?>
