<?php
/**
 * Best Companies Widget
 */

class Best_Companies_Widget extends WP_Widget {
    
    public function __construct() {
        parent::__construct(
            'best_companies_widget',
            'En İyi Firmalar',
            array('description' => 'En yüksek puanlı firmaları gösterir')
        );
    }
    
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);
        $number = !empty($instance['number']) ? absint($instance['number']) : 5;
        
        echo $args['before_widget'];
        
        if (!empty($title)) {
            echo $args['before_title'] . $title . $args['after_title'];
        }
        
        $query = new WP_Query(array(
            'post_type' => 'firma',
            'posts_per_page' => $number,
            'meta_key' => 'rating',
            'orderby' => 'meta_value_num',
            'order' => 'DESC'
        ));
        
        if ($query->have_posts()) :
            echo '<div class="best-companies">';
            $counter = 1;
            while ($query->have_posts()) : $query->the_post();
                $rating = get_post_meta(get_the_ID(), 'rating', true);
                $phone = get_post_meta(get_the_ID(), 'phone', true);
                ?>
                <div class="company-item">
                    <div class="company-rank"><?php echo $counter; ?></div>
                    <div class="company-info">
                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                        <?php if ($rating) : ?>
                            <div class="company-rating">
                                <?php 
                                for ($i = 1; $i <= 5; $i++) {
                                    echo $i <= $rating ? '⭐' : '☆';
                                }
                                ?>
                                <span>(<?php echo $rating; ?>/5)</span>
                            </div>
                        <?php endif; ?>
                        <?php if ($phone) : ?>
                            <div class="company-phone">📞 <?php echo $phone; ?></div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php
                $counter++;
            endwhile;
            echo '</div>';
            wp_reset_postdata();
        else :
            echo '<p>Henüz firma bulunmuyor.</p>';
        endif;
        
        echo $args['after_widget'];
    }
    
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'En İyi Firmalar';
        $number = !empty($instance['number']) ? $instance['number'] : 5;
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Başlık:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('number'); ?>">Gösterilecek Firma Sayısı:</label>
            <input class="tiny-text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3">
        </p>
        <?php
    }
    
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        $instance['number'] = (!empty($new_instance['number'])) ? absint($new_instance['number']) : 5;
        return $instance;
    }
}

// Register the widget
function register_best_companies_widget() {
    register_widget('Best_Companies_Widget');
}
add_action('widgets_init', 'register_best_companies_widget');
?>
